<?php

/*--------------------------------------------------------------------------------------------------
    TextOption.php 2019-06-11
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2019 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\StyleEdit\Core\Components\Url\Entities;

use Exception;
use Gambio\StyleEdit\Configurations\ShopBaseUrl;
use Gambio\StyleEdit\Core\Options\Entities\AbstractComponentOption;
use Gambio\StyleEdit\Core\SingletonPrototype;

/**
 * Class Url
 * @package Gambio\StyleEdit\Core\Components\TextBox\Entities
 */
class UrlOption extends AbstractComponentOption
{
    /**
     * @var string
     */
    protected const SHOP_BASE_URL_PATTERN = '#^__SHOP_BASE_URL__#';
    /**
     * @param $value
     *
     * @return boolean
     */
    protected function isValid($value): bool
    {
        return true;
    }
    
    
    /**
     * @param $value
     *
     * @return mixed
     * @throws Exception
     */
    protected function parseValue($value)
    {
        if (is_string($value) && preg_match(self::SHOP_BASE_URL_PATTERN, $value) === 1) {
            
            /** @var ShopBaseUrl $shopBaseUrl */
            $shopBaseUrl = SingletonPrototype::instance()->get(ShopBaseUrl::class);
            $value = preg_replace(self::SHOP_BASE_URL_PATTERN, $shopBaseUrl->value(), $value);
        }
        
        return $value;
    }
    
    
    /**
     * @return string
     */
    public function type(): ?string
    {
        return 'url';
    }
}